package com.agilex.healthcare.veteranappointment.dataservice;


import com.agilex.healthcare.veteranappointment.domain.DisabledFeatures;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisabledFeatureService {

    private final DisabledFeatures disabledFeatures;

    @Autowired
    public DisabledFeatureService(DisabledFeatures disabledFeatures) {
        this.disabledFeatures = disabledFeatures;
    }

    public DisabledFeatures getDisabledFeatures() {
        return disabledFeatures;
    }

    public boolean containsDisabledFeature(String disabledFeature) {
        for (String disabledFeatureItem : disabledFeatures.getDisabledFeatures()) {
            if (disabledFeatureItem.equalsIgnoreCase(disabledFeature)) {
                return true;
            }
        }

        return false;
    }
}
